#include <iostream>
#include <bits/stdc++.h>

using namespace std;

typedef long long ll;

const int mxN = 2 * 1e5 + 5;

/// BRUTE FORCE
vector<int> children[1005];
int color[1005];
int ans[1005];
int calc(int start)
{
    ans[start] = 1;
    for(int child : children[start])
    {
        ans[start] += calc(child);
        ans[start] -= color[start] == color[child];
    }
    return ans[start];
}
void setColor(int start, int newColor)
{
    color[start] = newColor;
    for(int child : children[start])
    {
        setColor(child, newColor);
    }
}
/// BRUTE FORCE


struct node
{
    int color;
    int ans;
    pair<bool, int> setColor;
};

struct segmentTree
{
    vector<node> val;
    int maxIndex;
    int size;

    void print()
    {
        cout << "\n";
        for(node n : val)
        {
            cout << "color " << n.color << " ans " << n.ans << "\n";
        }
        cout << "\n";
    }

    void build(int n, int index, int Lx, int Rx){}

    void build(int n, int index)
    {
        size = n;
        maxIndex = index;
        val = vector<node>(size * 2, {0,0});
    }

    void precalc(int index, int Lx, int Rx)
    {
        if(index >= maxIndex)
        {
            val[index] = {0,0};
            return;
        }
        val[index].ans = 1;
        if(Rx - Lx == 1)
        {
            return;
        }
        int m = (Lx+Rx)/2;
        precalc(index * 2 + 1, Lx, m);
        precalc(index * 2 + 2, m, Rx);
        val[index].ans += val[index * 2 + 1].ans + val[index * 2 + 2].ans;
        val[index].ans -= val[index * 2 + 1].color == val[index].color;
        val[index].ans -= val[index * 2 + 2].color == val[index].color;
    }

    void precalc()
    {
        precalc(0, 0, size);
    }

    /// conver index to l, r;
    pair<int,int> convert(int u)
    {
        stack<bool> operations;
        int index = u;
        while(index != 0)
        {
            index = (index - 1)/2;
            operations.push(index * 2 + 1 != u);
            u = index;
        }
        int Lx = 0, Rx = size;
        while(!operations.empty())
        {
            int top = operations.top();
            operations.pop();
            int m = (Lx+Rx)/2;
            if(top == 0)
            {
                Rx = m;
            }
            else
            {
                Lx = m;
            }
        }
        return {Lx, Rx};
    }

    void set(int index, int c)
    {
        if(index >= maxIndex) return;

        val[index].setColor = {true, c};
        val[index].color = c;
        val[index].ans = 1;
    }

    void change(int l, int r, int c, int index, int Lx, int Rx)
    {
        if(Lx >= r || Rx <= l) return;
        if(Lx >= l && Rx <= r)
        {
            set(index, c);
            return;
        }
        int m = (Lx+Rx)/2;
        if(val[index].setColor.first)
        {
            set(index * 2 + 1, val[index].setColor.second);
            set(index * 2 + 2, val[index].setColor.second);
            val[index].setColor = {false, 0};
        }
        change(l, r, c, index * 2 + 1, Lx, m);
        change(l, r, c, index * 2 + 2, m, Rx);
        val[index].ans = 1;
        val[index].ans += val[index * 2 + 1].ans + val[index * 2 + 2].ans;
        val[index].ans -= val[index * 2 + 1].color == val[index].color;
        val[index].ans -= val[index * 2 + 2].color == val[index].color;
    }

    void change(int u, int c) /// u = index
    {
        pair<int, int> help = convert(u);
        change(help.first, help.second, c, 0, 0, size);
    }

    int ans()
    {
        return val[0].ans;
    }
};


int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n, q;
    cin >> n >> q;
    if(n <= 1000 && q <= 1000) /// BRUTE FORCE
    {
        for(int i = 0; i < n - 1; i++)
        {
            int a, b;
            cin >> a >> b;
            a--;
            b--;
            if(a > b)
            {
                swap(a, b);
            }
            children[a].push_back(b);
        }
        for(int i = 0; i < n; i++)
        {
            cin >> color[i];
        }
        for(int i = 0; i < q; i++)
        {
            int u, c;
            cin >> u >> c;
            u--;
            setColor(u, c);
            cout << calc(0) << "\n";
        }
        return 0;
    }
    /// binary tree grebem se za dvaes bodova LETS GO
    int total = 0;
    int pow2 = 1;
    int stepen = 0;
    while(total < n)
    {
        total += pow2;
        pow2 <<= 1;
        stepen++;
    }
    pow2 >>= 1; /// aj proveri ovo keve ti edit: proverio
    segmentTree tree;
    tree.build(pow2, n);
    for(int i = 0; i < n - 1; i++)
    {
        int trash;
        cin >> trash >> trash;
    }
    for(int i = 0; i < n; i++)
    {
        cin >> tree.val[i].color;
    }
    tree.precalc();
    //tree.print();
    for(int i = 0; i < q; i++)
    {
        int u, c;
        cin >> u >> c;
        u--;
        tree.change(u, c);
        cout << tree.ans() << "\n";
        //tree.print();
    }
}

/*
5 5
1 2
1 3
2 4
2 5
1 2 3 1 2
2 1
2 2
5 1
3 1
1 1*/